# Запретный плод уже сорван

Астрофизик Дэвид Киппинг попал на закрытую встречу в Институте перспективных исследований Принстона. Вернулся потрясённым и записал часовой подкаст. Я послушал его весь, чтобы вам не пришлось.

В январе Дэвид Киппинг приехал в Принстон читать коллоквиум по астрономии. В коридоре Института перспективных исследований он разминулся с Эдом Виттеном — одним из отцов теории струн. Просто разминулся, как люди часто расходятся в коридорах. По этому же коридору ходили Эйнштейн, Оппенгеймер, Гёдель. Место не из тех, где привыкли потакать чуши.

Киппинг — профессор Колумбийского университета, автор YouTube-канала Cool Worlds (полтора миллиона подписчиков), десять лет в ML/AI. Восемь лет назад перестал сам разрабатывать модели: не успевал за литературой и решил, что либо ты full-time в ИИ, либо используешь всё это как инструмент. Выбрал второе. Публикации по предсказанию стабильности циркумбинарных планет, обнаружению «пропущенных» экзопланет. Действующий учёный с портфолио исследователя, а не журналист и не праздный блогер.

На следующий день он по привычке заглянул в IAS и попал на закрытое совещание. Организовал его один из старших профессоров-астрофизиков (имя Киппинг намеренно не называет). Тема: влияние ИИ на науку. Сорок минут презентации, затем комментарий историка по зуму, затем дискуссия. В зале человек тридцать, среди них авторы космологических симуляций Enzo, Illustris, Gadget. Гидродинамика с адаптивными сетками, сотни тысяч строк C и Fortran. Попробуйте, как выразился Киппинг, найти комнату с более высоким средним IQ.

Встреча была внутренней: без камер, без пресс-релизов, без подготовленных заявлений. Не конференция, не рекламное мероприятие. Именно поэтому люди говорили то, что думают.

Историк высказался первым: это исторический момент, его необходимо документировать.

Зал засмеялся. Киппинг — нет.
Капитуляция

Первое утверждение ведущего: ИИ кодит на порядок лучше людей. Именно так — полное доминирование, качество кода выше на порядок. Ни один человек в зале не поднял руку возразить. Ни один.

Затем пошли числа. Ведущий профессор сказал, что ИИ способен выполнять около девяноста процентов его интеллектуальной работы. Оговорился: может, шестьдесят, может, девяносто девять. Но ясно дал понять, что больше половины, и доля будет расти. Речь шла не только про код. Аналитическое мышление, математика, решение задач. Всё то, чему человек в IAS посвятил жизнь.

Конкретный пример от Киппинга. Он работал над взятием интеграла в Mathematica, основном инструменте символьных вычислений, продукте Стивена Вольфрама. Mathematica не справилась. ChatGPT 5.2 справился. Показал полную цепочку подстановок и преобразований, чего Mathematica не делает в принципе. Результат проверили численно. Сошёлся.

Когда человек из IAS (напомню — здесь работал Гёдель) — признаётся, что модель выполняет девяносто процентов его мыслительной работы, никакой маркетолог не сочинил бы формулировку страшнее. Кризис идентичности, высказанный вслух, при свидетелях. Свидетели кивали и радовались.
Ключ от квартиры, где деньги лежат

Ведущий профессор передал агентным системам полный контроль над своей цифровой жизнью. Электронная почта, файлы, серверы, календари. Root-доступ в терминах Unix. Основные инструменты — Claude и Cursor, GPT на подхвате. Примерно треть зала подняла руки: мы тоже.

Кто-то спросил про приватность: вы хотя бы пользовательское соглашение читали?

Ответ: «Мне всё равно. Преимущество настолько велико, что потеря приватности нерелевантна.»

Дальше про этику. Были перечислены стандартные опасения: рабочие места, энергопотребление, климат, власть миллиардеров. Ведущий их признал. И буквально сказал: мне всё равно, преимущество слишком велико. Киппинг описывает настроение зала как «к чёрту этику». Это было не изолированное мнение чудака-радикала. Зал соглашался.

Тут стоит остановиться и подумать, что именно мы наблюдаем. Академики — мастера дипломатических оговорок. Вся их карьера — навык сказать «есть нюансы» вместо «да» или «нет». И вот эти самые люди, в закрытом кругу, без камер, говорят «мне наплевать на этику». Сама позиция предсказуема (если твоя работа — максимизация научного результата, ты оптимизируешь свою работу под результат). Но готовность сказать это вслух, без оговорок — вот что показывает уровень давления, которое они ощущают. Раньше даже в курилке так формулировать стеснялись.

Метафора, которой Киппинг описал ситуацию: «запретный плод». ИИ-компании — это змей, протягивающий яблоко. Откусив однажды, невинность не вернёшь. А если ты не откусишь, а конкурирующая лаборатория откусит — она тебя обгонит. Гонка вооружений с моральной дилеммой внутри.

Что характерно, это ощущение неизбежности не абстрактное, его подтверждает опыт. Киппинг описывает свой собственный рабочий процесс: пруфридинг статей (LaTeX прямо в GPT), вайбкодинг (хотя бо́льшую часть кода пока пишет сам), отладка (почти никогда не дебажит вручную, копирует ошибку в чат), литературный поиск, вычисление производных для статей, и даже междисциплинарная работа: когда для проекта TARS понадобилось разобраться в свойствах графена, альбедо и механической прочности, он провёл всё через ИИ. Для ютуба: DXRevive для очистки аудио, lalalai.ai для отделения музыки, Rev.com для транскриптов, Topaz для апскейлинга, GPT для фактчекинга скриптов.

При этом Киппинг сам себя суперпользователем не считает. Его самооценка: «Моя сила всегда была в креативности — ИИ её усиливает.» А ведущий профессор, по рассказу Киппинга, ушёл значительно дальше. Между «использую для пруфридинга» и «отдал root к серверам» — пропасть, и в этой пропасти живут все стадии принятия, через которые учёные проходят за год-два.

    Shameless plug. Заходите на мой канал про нейросети:
    "Откровения от Олега" (https://t.me/tg_1red2black)

Как растёт доверие

Вот тут может быть интересно тем, кто работает с alignment, interpretability, или просто настраивает агентные пайплайны на проде.

Ведущий профессор описал свою траекторию. Начинал с Cursor — потому что Cursor показывает diff. Вот что было, вот что стало, вот что я изменил в твоём коде. Прозрачно, проверяемо, привычно программисту. Но по мере того как доверие росло, прозрачность стала раздражать. Она перестала ощущаться как безопасность и начала ощущаться как трение. Профессор перешёл на Claude. Claude отправляет суб-агентов, декомпозирует задачу, решает по кускам, действует автономнее. Не показывает каждый diff. Просто делает.

Проверку профессор организовал между моделями: решал задачу в Cursor, перепроверял в Claude, обсуждал результат в GPT. Фактически peer review. Только не между коллегами, а между тремя нейросетями.

Если выписать эту траекторию формально, получится S-кривая: скепсис, разочарование, инвестиция времени, удивление, доверие, передача контроля. На последней фазе прозрачность превращается в помеху — как жужжание мухи, когда пытаешься сосредоточиться. Ведущие учёные мира стоят на верхнем плато этой кривой.

Вот что это означает для всех, кто строит интерпретируемые и объяснимые системы: пользователям высокого уровня ваша прозрачность не нужна. Они её отключат. Не потому что их заставили, не потому что интерфейс плохой — потому что им удобнее без неё. Естественный отбор внутри пользовательского поведения давит в сторону менее интерпретируемых систем. Для alignment-сообщества это должно быть тревожным сигналом: чем лучше модели работают, тем меньше у пользователей стимулов за ними присматривать.

Побочный эффект: мелкие научные коллаборации начнут исчезать. Раньше учёный привлекал соавтора, потому что ему не хватало навыка — расчёта, проверки, кода в незнакомой библиотеке. Теперь этот пробел закрывает модель. Зачем звать коллегу ради одного расчёта, если Claude сделает за десять минут? Киппинг сам пишет научные работу в одиночку, что для его поля необычно, и предполагает, что тренд усилится. Останутся ядровые коллаборации — по две-три человека, где каждый незаменим. Остальное возьмут на себя агенты.

При этом первый контакт с моделями обычно разочаровывает. Ведущий профессор признал, что потратил огромное количество времени на пробы и ошибки. Часами кричал в клавиатуру заглавными буквами. Люди пробуют один раз, получают мусор, бросают. Те, кто прошёл через это, — ранние последователи — получают колоссальное преимущество. Отсюда и мотивация встречи: институт не сопротивлялся, а формировал группу для ускоренного внедрения. Послание было однозначным: возьмите это в работу, расслабьтесь и получайте удовольствие.
Экономика ловушки

Ведущий профессор тратил сотни долларов в месяц на подписки. Из личных средств. Для него это терпимо. Для аспиранта или молодого постдока уже барьер. Расслоение идёт прямо сейчас: одним ИИ усиливает работу, другие не могут себе позволить усилитель.

Масштаб инвестиций в индустрию ИИ с 2014 года превышает весь проект «Аполлон» более чем в пять раз (с поправкой на инфляцию) и в пятьдесят раз — Манхэттенский проект. Таких денег человечество не вкладывало ни в одну технологию.

Вопрос, который прозвучал за обедом: как инвесторы вернут эти суммы? Один сценарий — ценовая ловушка. Классическая дилерская схема: первая доза бесплатно. Модели сейчас дёшевы. Все привыкают. Навыки атрофируются. Через пару лет компании задирают цену до тысяч долларов в месяц. К тому моменту овертоново окно сдвинулось: уровень продуктивности с ИИ стал ожидаемой нормой, и отказаться уже невозможно — как от GPS, привычка есть, а навыки жить без навигатора давно отмерли.

Второй сценарий обсуждали на обеде с особым жаром: ИИ-компании могут потребовать долю от интеллектуальной собственности. Представьте условия сервиса, где OpenAI или Anthropic забирают десять-двадцать-пятьдесят процентов патентов за использование «исследовательского» тарифа. Пока это спекуляция. Но двести миллиардов долларов инвестиций требуют возврата, и благотворительностью тут не обойтись.

Эту тему почти никто не обсуждает публично. А зря: если ваш грант оплачивает работу, а двадцать процентов IP уходит Anthropic — это другая экономика исследований.
Кому хуже всех

Традиционно в физике и астрофизике выигрывали технически подкованные люди. Способность решать дифференциальные уравнения в голове, писать сложные симуляции, мыслить абстрактно. Эти преимущества нейтрализованы появлением ИИ.

Новый профиль «суперучёного» — менеджерский. Умение разбить проблему на куски, пригодные для модели. Терпение — не срываться, когда модель в третий раз отвечает уверенным бредом. Навык строить рабочий процесс: промпты, правила, цепочки агентов. Совсем другая порода людей, чем те, что двигали науку последние триста лет. Как если бы дирижёру сказали: оркестр теперь виртуальный, палочку можешь выбросить, учись писать MIDI.

Аналогия с GPS точна и жестока. До навигаторов мы держали в голове трёхмерную карту местности. GPS этот навык убил. За рулём мы теперь думаем о чём угодно, только не о маршруте. Атрофия навыков кодирования, математического мышления, самостоятельного решения задач: то же самое, только масштабнее.

Самая уязвимая группа: молодые учёные. Подготовка PhD-студента стоит около ста тысяч долларов в год — зарплата, медицинская страховка, tuition. Подписка на модель: двадцать долларов в месяц. Проект первого года, на который студент тратит двенадцать месяцев, модель проглатывает за вечер.

На фоне этого — урезание федеральных грантов текущей администрацией. И экзистенциальный вопрос, который Киппинг явно маркирует как «я не за это, но могу представить, что кто-то скажет»: зачем тратить пять лет на подготовку учёного, если через пять лет учёных в привычном понимании может не быть?

Штатные профессора в относительной безопасности — по определению тенюры, чтобы их уволить, нужно ликвидировать институт целиком. Капитаны, которые пойдут ко дну вместе с кораблём. Часть корабля, часть команды.

Ведущий профессор уже использует ИИ для отбора аспирантов — не для принятия решений, но для ассистирования. Результат этого внедрения оценивает как лучший за всю практику: быстрее, точнее, надёжнее.

Вопрос, от которого мурашки по коже: по каким критериям отбирать студентов, если традиционные (техническое мастерство, умение кодить, абстрактная математика) через пять лет могут оказаться бессмысленными? Киппинг формулирует жёстко: согласился бы он работать со студентом, который принципиально отказывается использовать ИИ? Скорее всего, нет. Это как принципиально не пользоваться интернетом или отказываться писать код.
О чем молчат на конференциях

Есть вещи, которые на встрече не прозвучали, но их тень ложится на каждый факт из подкаста.

Если модели пишут девяносто процентов работы и кросс-чекают друг друга, кто заметит систематическую ошибку, общую для всех? Когда все пользуются одними и теми же системами, разнообразие взглядов сужается. Предположим, три модели согласны, что интеграл берётся так-то. А если все три унаследовали одну и ту же аппроксимацию из тренировочных данных? Отдельный человек-рецензент с карандашом мог бы поймать — но рецензентов завалили бумагами, у них нет времени, и они тоже всё чаще проверяют через модель.

Воспроизводимость и так больная тема в науке (гуглите replication crisis, если не в курсе: половина результатов в психологии не воспроизводится, в биомедицине картина ненамного лучше). Теперь добавьте сюда: эксперимент «запустил промпт, получил результат». Как его воспроизвести через год, когда модель обновилась? Какой была температура сэмплирования? Какой system prompt стоял по умолчанию в тот вторник? Какая версия модели использовалась? Воспроизводимость получает либо второе дыхание, либо контрольный выстрел. Зависит от того, научимся ли мы фиксировать промпт-окружение так же строго, как фиксируем версии библиотек в requirements.txt.

Если модели генерируют науку, а наука попадает в данные для обучения следующего поколения моделей, это замкнутый цикл. Сходится он к чему-то осмысленному или расходится, мы не знаем. Model collapse как концепция обсуждается широко, но в конкретном контексте научного знания почти нигде. А ведь научные тексты устроены иначе, чем копирайтинг: там цепочки рассуждений, где ошибка в середине ломает всю логику. Если модель обучится на десяти тысячах статей, где промежуточный шаг — плод галлюцинаций, но конечный результат случайно совпал с реальностью, она усвоит плохие рассуждения вместе с правильными ответами. Это даже хуже, чем откровенная ошибка.

Ещё одна тема, которую Киппинг затрагивает, но в другом контексте: публичная реакция. У аудитории YouTube сильнейшая аллергия на всё, что пахнет «AI slop» — контент, целиком сгенерированный моделью, пережёванная Википедия, рерайт Reddit. Киппинг проводит границу: его контент основан на уникальных идеях, модель помогает с исполнением и оформлением, а не с идеями. Но вот что показательно — учёных в IAS реакция публики вообще не волновала. Они не боятся, что статью назовут сгенерированной, потому что давно признали: модели работают на их уровне или выше. С их точки зрения, AI-assisted наука абсолютно легитимна. Разрыв между академическим восприятием и публичным — уже пропасть, и пропасть будет расти.

Бумажный шторм. Появляется один-два порядка больше публикаций. Супермены пишут по три-четыре статьи в год вместо одной, а «обычные люди с GPT» обрели возможность тоже писать свои. Уже сейчас на arXiv ежедневно выкладывают десятки работ в каждой области знаний. Читать некому. «Используй ИИ для чтения» — ответ на поверхности, но учёному нужно не summary получить, а знание интернализировать. Загнать в голову, переварить, связать с тем, что уже знаешь. Саммари этого не даёт.
Последний вопрос

Какой смысл заменять всех учёных машинами?

Киппинг приводит аналогию с искусством. ИИ-арт существует, и для некоторых задач он полезен. Но в музее нас цепляет человеческая история: что двигало художником, что происходило вокруг, почему именно такой мазок именно в этом месте. Наука — та же природа любопытства. Детективная работа. Радость, когда кусочки складываются и ты вдруг понимаешь, как устроен фрагмент мира.

Киппинг боится вполне определенных вещей. Мир, в котором сверхинтеллект проектирует термоядерный реактор, а люди не в состоянии понять, как он устроен. Мир, где результат есть, а понимания нет. Где всё вокруг — магия. Он говорит: «Я не знаю, хочу ли я жить в мире, где всё — просто магия, фантазия. Я хочу жить в постижимом мире.»

Если подставить числа: модель стоит двадцать долларов и делает работу PhD-студента. Значит, наука перестаёт быть привилегией элиты. Зрители канала Киппинга, которые годами писали ему с идеями, больше не нуждаются в Киппинге для их реализации. «Демократизация». Звучит прекрасно. Но последствие — лавина публикаций, в которых человеческое внимание становится главным дефицитом. Ценности сдвигаются: не «кто может заниматься наукой», а «кто способен отделить в ней зерно от шелухи». Совсем другой навык. И, возможно, последний, которым человек обязан будет уметь пользоваться.

Каспаров проиграл Deep Blue в 97-м. Потом десять лет продвигал идею «кентаврических шахмат»: человек плюс машина сильнее, чем машина в одиночку. К 2015 году выяснилось, что нет — машина одна сильнее. Кентавры сошли со сцены тихо и без почётных проводов. В науке мы сейчас где-то в фазе кентавра: человек ещё нужен, человек ещё управляет процессом, человек ещё формулирует вопросы. Сколько это продлится — вопрос не абстрактный. Для кого-то из тех аспирантов, которых сейчас отбирают, ответ наступит до защиты диссертации.

Самое поразительное в этом подкасте не содержание. Любой, кто ежедневно работает с LLM, узнает в нём собственные мысли. Поразительно другое. Киппинг говорит: шокировало не то, что он услышал, а то, что всё это было произнесено вслух, и весь зал кивал. Мысли, которые он считал своими личными тревогами, неуверенные, полуоформленные, пугающие, оказались общим хором. Просто до того январского утра никто не решался сказать.

Тот историк, который там выступал через Zoom, оказался прав: этот момент нужно документировать. Киппинг задокументировал. Я записал текстом. Хаброжители прочитали.

А вот кто будет читать через пять лет — мы сами, или системы, которым мы к тому времени делегируем чтение, — на этот вопрос в той комнате никто не ответил.

Впрочем, может, и не нужно было. Достаточно того, что его задали.

По материалам подкаста Cool Worlds (David Kipping, Columbia University), эпизод о закрытой встрече в Institute for Advanced Study, Принстон, 2025.

https://habr.com/ru/companies/bar/articles/992842/

https://coolworldslab.podbean.com/e/30-solo-episode-we-need-to-talk-about-ai/